 /*
 * MAIN Generated Driver File
 * 
 * @file main.c
 * 
 * @defgroup main MAIN
 * 
 * @brief This is the generated driver implementation file for the MAIN driver.
 *
 * @version MAIN Driver Version 1.0.0
*/

/*
 [2024] Microchip Technology Inc. and its subsidiaries.

    Subject to your compliance with these terms, you may use Microchip 
    software and any derivatives exclusively with Microchip products. 
    You are responsible for complying with 3rd party license terms  
    applicable to your use of 3rd party software (including open source  
    software) that may accompany Microchip software. SOFTWARE IS ?AS IS.? 
    NO WARRANTIES, WHETHER EXPRESS, IMPLIED OR STATUTORY, APPLY TO THIS 
    SOFTWARE, INCLUDING ANY IMPLIED WARRANTIES OF NON-INFRINGEMENT,  
    MERCHANTABILITY, OR FITNESS FOR A PARTICULAR PURPOSE. IN NO EVENT 
    WILL MICROCHIP BE LIABLE FOR ANY INDIRECT, SPECIAL, PUNITIVE, 
    INCIDENTAL OR CONSEQUENTIAL LOSS, DAMAGE, COST OR EXPENSE OF ANY 
    KIND WHATSOEVER RELATED TO THE SOFTWARE, HOWEVER CAUSED, EVEN IF 
    MICROCHIP HAS BEEN ADVISED OF THE POSSIBILITY OR THE DAMAGES ARE 
    FORESEEABLE. TO THE FULLEST EXTENT ALLOWED BY LAW, MICROCHIP?S 
    TOTAL LIABILITY ON ALL CLAIMS RELATED TO THE SOFTWARE WILL NOT 
    EXCEED AMOUNT OF FEES, IF ANY, YOU PAID DIRECTLY TO MICROCHIP FOR 
    THIS SOFTWARE.
*/
#include "mcc_generated_files/system/system.h"
#include "Filament_Dryer.h"

/*
    Main application
*/

/*******************************************************************************
  Function:
    void Dryer_Initialize ( void )

  Remarks:
    See prototype in util.h.
******************************************************************************/
void Dryer_Initialize ( void )
{
    /* Place the App state machine in its initial state. */
    Dryer_Data.state                    = DRYER_STATE_INIT;
    Dryer_Data.Timer_Runtime            = 0;
    Dryer_Data.Timer_Time               = 0;
    Dryer_Data.Timer_Temp               = 0;
    Dryer_Data.Second_Counter           = 0; 
    Dryer_Data.Vent_Timer               = 0;
    Dryer_Data.Heater_Output_Disable    = 1; /* definitely start off! */
    Dryer_Data.Vent_Fan_Output          = 0; /* start off */
}



int main(void)
{
    int PortA_Read, loop;    


    SYSTEM_Initialize();
    INTERRUPT_GlobalInterruptDisable(); 
    INTERRUPT_PeripheralInterruptDisable(); 

    // initialise the data structures and state machine
    Dryer_Initialize();
    __delay_ms(startup_delay);
    /* Check the application's current state. */
    do{
        switch ( Dryer_Data.state )
        {
            /* Application's initial state. */
            case DRYER_STATE_INIT:
            {
                // some configuration stuff to get things rolling 
                WDTCON=0;       //off under software control
                OSCFRQ=2;       //4MHz - this should be fine for this application
                __delay_ms(settle_time);  /* let the port settle */
                /* make sure the heater is disabled */
                Stop_Heater;
               
                /* Run the vent fan for a while to tell me things are there*/
                for (loop = 0; loop < 4; loop++)
                {
                    Run_Vent_Fan;
                    __delay_ms(short_vent_on_boot_time);  /* so we can hear things happening */
                    Stop_Vent_Fan;   
                    __delay_ms(short_vent_on_boot_time);  /* so we can hear things happening */ 
                };
                Stop_Vent_Fan;   
                                                                                                                                                                                                                                                                                                                    __delay_ms(vent_delay_on_boot_time);  /* so we can hear things happening */

                Dryer_Data.state = DRYER_STATE_IDLE;
                               
            }
            break;

            
            case DRYER_STATE_IDLE:
            {
                Stop_Heater;
                Stop_Vent_Fan;
                
                Dryer_Data.Timer_Time = 0;  /* reset timer */
                PortA_Read =  Read_Port_A_Inputs;
                if (Start_Read ==0)
                  {
                    if (PortA_Read & Time_6h_Addr)
                    {
                        Dryer_Data.Timer_Runtime = Time_6hr_Runtime;
                        Dryer_Data.Vent_Timer = Vent_Runtime;
                        Dryer_Data.state = DRYER_STATE_COUNTING ;                    }
                    else if (PortA_Read & Time_12h_Addr)
                    {
                        Dryer_Data.Timer_Runtime = Time_12hr_Runtime;
                        Dryer_Data.Vent_Timer = Vent_Runtime;
                        Dryer_Data.state = DRYER_STATE_COUNTING ;                    }
                    else   /* SEND IT BACK TO IDLE */
                    {
                        Dryer_Data.state = DRYER_STATE_IDLE ;
                        Dryer_Data.Timer_Runtime = 0;
                        Dryer_Data.Vent_Timer = 0;
                        Stop_Heater;
                        Stop_Vent_Fan;
                    };
                }
            }
            break;
            
            case DRYER_STATE_COUNTING:
            {
                Run_Heater;
                /* check if we want to run the fan - just not when we are done*/
                if (Dryer_Data.Timer_Runtime > 0)
                {
                    if ((Dryer_Data.Timer_Runtime % Vent_Interval) == 0)
                    {
                        Dryer_Data.Vent_Timer = Vent_Runtime;
                        Run_Vent_Fan;
                    }
                    else;
                };

                __delay_ms(Counting_Timer);  /* Reasonable time steps */

                Dryer_Data.Timer_Runtime --; /* decrement heater timer */
                if (Dryer_Data.Timer_Runtime == 0)
                {
                    /* we are done here */
                    Stop_Heater;
                    Stop_Vent_Fan;
                    Dryer_Data.Timer_Runtime = 0;
                    Dryer_Data.Vent_Timer = 0;
                    Dryer_Data.state = DRYER_STATE_IDLE ;  /* go back to idle */
                };
                
                
                if(Dryer_Data.Vent_Timer > 0){
                    Dryer_Data.Vent_Timer--;
                }
                if(Dryer_Data.Vent_Timer == 0)
                    Stop_Vent_Fan;
            }
            break;
        }
        
    } while(1); // for ever
    
    return (0);
}